/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.projects.templates;

import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.core.projects.templates.ProjectTemplate;
import com.aptana.core.projects.templates.TemplateType;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.ResourceUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.projects.templates.IDefaultProjectTemplate;
import com.aptana.projects.templates.IProjectTemplateListener;
import com.aptana.projects.templates.Messages;
import com.aptana.scripting.model.AbstractElement;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.ElementVisibilityListener;
import com.aptana.scripting.model.ProjectTemplateElement;
import com.aptana.scripting.model.filters.IModelFilter;
import com.aptana.ui.util.UIUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectTemplatesManager {
    public static final String TAG_OTHERS = Messages.ProjectTemplatesManager_OthersTagName;
    private static final String EXTENSION_POINT = "projectTemplates";
    private static final String ELEMENT_TEMPLATEINFO = "templateInfo";
    private static final String ELEMENT_LOCAL = "local";
    private static final String ELEMENT_REMOTE = "remote";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_LOCATION = "location";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_ICON = "icon";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_ID = "id";
    private static final String ATTR_REPLACE_PARAMETERS = "replaceParameters";
    private Map<TemplateType, Set<IProjectTemplate>> projectTemplates;
    private ImageRegistry templateTagsImageRegistry;
    private ElementVisibilityListener elementListener = new ElementVisibilityListener(){

        public void elementBecameHidden(AbstractElement element) {
            if (element instanceof ProjectTemplateElement) {
                ProjectTemplateElement template = (ProjectTemplateElement)element;
                ProjectTemplatesManager.this.removeTemplate((IProjectTemplate)template);
            }
        }

        public void elementBecameVisible(AbstractElement element) {
            if (element instanceof ProjectTemplateElement) {
                ProjectTemplateElement template = (ProjectTemplateElement)element;
                ProjectTemplatesManager.this.addTemplate((IProjectTemplate)template);
            }
        }
    };
    private List<IProjectTemplateListener> templateListeners;

    public ProjectTemplatesManager() {
        this.projectTemplates = new HashMap<TemplateType, Set<IProjectTemplate>>();
        this.templateListeners = new ArrayList<IProjectTemplateListener>();
        this.readExtensionRegistry();
        this.loadTemplatesFromBundles();
        BundleManager.getInstance().addElementVisibilityListener(this.elementListener);
    }

    public void dispose() {
        BundleManager.getInstance().removeElementVisibilityListener(this.elementListener);
    }

    public void addListener(IProjectTemplateListener listener) {
        if (!this.templateListeners.contains(listener)) {
            this.templateListeners.add(listener);
        }
    }

    public void removeListener(IProjectTemplateListener listener) {
        this.templateListeners.remove(listener);
    }

    public List<IProjectTemplate> getTemplatesForType(TemplateType projectType) {
        Set<IProjectTemplate> templates = this.projectTemplates.get(projectType);
        if (templates == null) {
            return Collections.emptyList();
        }
        return new ArrayList<IProjectTemplate>(templates);
    }

    public List<IProjectTemplate> getTemplates(TemplateType[] projectTypes) {
        ArrayList<IProjectTemplate> templates = new ArrayList<IProjectTemplate>();
        TemplateType[] templateTypeArray = projectTypes;
        int n = projectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateType type = templateTypeArray[n2];
            templates.addAll(this.getTemplatesForType(type));
            ++n2;
        }
        return templates;
    }

    public Image getImageForTag(String tag) {
        ImageRegistry reg = this.getImageRegistry();
        if (reg != null) {
            return reg.get(tag);
        }
        return null;
    }

    public void putImageForTag(String tag, ImageDescriptor imageDescriptor) {
        ImageRegistry reg = this.getImageRegistry();
        if (reg != null) {
            reg.put(tag, imageDescriptor);
        }
    }

    protected ImageRegistry getImageRegistry() {
        try {
            if (this.templateTagsImageRegistry == null) {
                this.templateTagsImageRegistry = new ImageRegistry(UIUtils.getDisplay());
            }
            return this.templateTagsImageRegistry;
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    private void readExtensionRegistry() {
        EclipseUtil.processConfigurationElements((String)"com.aptana.projects", (String)EXTENSION_POINT, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

            public void processElement(IConfigurationElement element) {
                ProjectTemplatesManager.this.readElement(element);
            }

            public Set<String> getSupportElementNames() {
                return CollectionsUtil.newSet((Object[])new String[]{ProjectTemplatesManager.ELEMENT_TEMPLATEINFO});
            }
        });
    }

    private void readElement(IConfigurationElement element) {
        if (ELEMENT_TEMPLATEINFO.equals(element.getName())) {
            String id;
            String description;
            String path = null;
            Bundle bundle = Platform.getBundle((String)element.getNamespaceIdentifier());
            IConfigurationElement[] localPaths = element.getChildren(ELEMENT_LOCAL);
            if (localPaths.length > 0) {
                String location = localPaths[0].getAttribute(ATTR_LOCATION);
                URL url = bundle.getEntry(location);
                path = ResourceUtil.resourcePathToString((URL)url);
            } else {
                IConfigurationElement[] remotePaths = element.getChildren(ELEMENT_REMOTE);
                if (remotePaths.length > 0) {
                    path = remotePaths[0].getAttribute(ATTR_LOCATION);
                }
            }
            if (StringUtil.isEmpty(path)) {
                return;
            }
            TemplateType type = TemplateType.valueOf((String)element.getAttribute(ATTR_TYPE).toUpperCase());
            String name = element.getAttribute(ATTR_NAME);
            if (name == null) {
                name = "";
            }
            if ((description = element.getAttribute(ATTR_DESCRIPTION)) == null) {
                description = "";
            }
            String icon = element.getAttribute(ATTR_ICON);
            URL iconURL = null;
            if (icon != null) {
                iconURL = bundle.getEntry(icon);
            }
            if ((id = element.getAttribute(ATTR_ID)) == null) {
                id = "";
            }
            boolean replacingParameters = Boolean.parseBoolean(element.getAttribute(ATTR_REPLACE_PARAMETERS));
            this.addTemplate((IProjectTemplate)new ProjectTemplate(path, type, name, replacingParameters, description, iconURL, id));
        }
    }

    private void loadTemplatesFromBundles() {
        List templates = BundleManager.getInstance().getProjectTemplates(new IModelFilter(){

            public boolean include(AbstractElement element) {
                return element instanceof ProjectTemplateElement;
            }
        });
        for (IProjectTemplate template : templates) {
            this.addTemplate(template);
        }
    }

    public void addTemplate(IProjectTemplate template) {
        TemplateType type = template.getType();
        Set<IProjectTemplate> templates = this.projectTemplates.get(type);
        if (templates == null) {
            templates = new TreeSet<IProjectTemplate>(new ProjectTemplateComparator());
            this.projectTemplates.put(type, templates);
        }
        templates.add(template);
        this.fireTemplateAdded(template);
    }

    public void removeTemplate(IProjectTemplate template) {
        TemplateType type = template.getType();
        Set<IProjectTemplate> templates = this.projectTemplates.get(type);
        if (templates != null) {
            templates.remove(template);
            this.fireTemplateRemoved(template);
        }
    }

    private void fireTemplateAdded(IProjectTemplate template) {
        for (IProjectTemplateListener listener : this.templateListeners) {
            listener.templateAdded(template);
        }
    }

    private void fireTemplateRemoved(IProjectTemplate template) {
        for (IProjectTemplateListener listener : this.templateListeners) {
            listener.templateRemoved(template);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProjectTemplateComparator
    implements Comparator<IProjectTemplate> {
        private ProjectTemplateComparator() {
        }

        @Override
        public int compare(IProjectTemplate pt1, IProjectTemplate pt2) {
            boolean isPt1Default = pt1 instanceof IDefaultProjectTemplate;
            boolean isPt2Default = pt2 instanceof IDefaultProjectTemplate;
            if (isPt1Default && isPt2Default || !isPt1Default && !isPt2Default) {
                return pt1.getDisplayName().compareTo(pt2.getDisplayName());
            }
            if (isPt1Default) {
                return -1;
            }
            return 1;
        }
    }
}

